/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.file_server;

import ibm.nways.nhm.file_server.RemoteFileServer;
import ibm.nways.nhm.file_server.RemoteOutputHandle;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

public class RemoteOutputStream
extends OutputStream {
    private RemoteOutputHandle out;

    public RemoteOutputStream(String string) throws IOException, RemoteException, NotBoundException {
        this(string, false);
    }

    public RemoteOutputStream(String string, boolean bl) throws IOException, RemoteException, NotBoundException {
        String string2 = "rmi://localhost/RFSI";
        RemoteFileServer remoteFileServer = (RemoteFileServer)Naming.lookup(string2);
        this.out = remoteFileServer.getOutStream(string, bl);
    }

    public RemoteOutputStream(String string, String string2, int n) throws IOException, RemoteException, NotBoundException {
        this(string, string2, n, false);
    }

    public RemoteOutputStream(String string, String string2, int n, boolean bl) throws IOException, RemoteException, NotBoundException {
        String string3 = "rmi://" + string2 + ":" + String.valueOf(n) + "/RFSI";
        RemoteFileServer remoteFileServer = (RemoteFileServer)Naming.lookup(string3);
        this.out = remoteFileServer.getOutStream(string, bl);
    }

    public void close() throws IOException {
        try {
            this.out.close();
            return;
        }
        catch (RemoteException remoteException) {
            throw new IOException("Remote error: " + remoteException);
        }
    }

    public void flush() throws IOException {
        try {
            this.out.flush();
            return;
        }
        catch (RemoteException remoteException) {
            throw new IOException("Remote error: " + remoteException);
        }
    }

    public void write(int n) throws IOException {
        try {
            this.out.write(n);
            return;
        }
        catch (RemoteException remoteException) {
            throw new IOException("Remote error: " + remoteException);
        }
    }

    public void write(byte[] byArray) throws IOException {
        try {
            this.out.write(byArray);
            return;
        }
        catch (RemoteException remoteException) {
            throw new IOException("Remote error: " + remoteException);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.out.write(byArray, n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new IOException("Remote error: " + remoteException);
        }
    }
}

